# AX3 Email

AX3 Email A Django app to send emails using Huey tasks

## Installation
AX3 Email is easy to install from the PyPI package:

```bash
$ pip install ax3-email
```

After installing the package, the project settings need to be configured.
add `ax3_email` to your `INSTALLED_APPS`

`INSTALLED_APPS += [ax3_email]`
## Configuration

Add email backend settings

```python 
# app/settings.py
EMAIL_BACKEND = 'ax3_email.backends.AX3EmailBackend'
AX3_EMAIL_BACKEND = 'django.core.mail.backends.console.EmailBackend' # Django Email that does the actual sending // Optional - Default smtp (django)
AX3_RETRIES  # Maximum number of times to retry // Optional - Default 3
AX3_DELAY # Time in seconds between attempts // Optional - Default = 600
EMAIL_SUBJECT # Optional string format for all email subjects // example for prefix '[ax3_prefix] {} '
EMAIL_BACKUP_LIST # Optional list of emails to send a bcc backup copy
```
